* Purpose: calcualting preferred annual net monetary benefit or cost of credit card holding
* Date last edited: 02 October 2018
* File author: Mary-Alice Doyle

*------------------------------------------------
* 
********
* SUMMARY OF METHOD
********
quietly {
* COMPONENTS CALCULATED AS FOLLOWS
* REWARDS
* value of rewards = points earn rate based on points needed for a $100 gift card or $100 value of flights (depending on response to questiton q7a) 
//* monthly spend * 12 * Seasonal Factor from October 2016 RBA Retail Payment Statistics (RPS)


* ANNUAL FEE
* = annual fee from Card features database (CFD) * waived/discounted indicator 
* assuming discount of 50 per cent if discounted - this rate based on range of first-year discounts from CFD

* INTEREST-FREE PERIOD
* alternative interest rate is from Nov 16 RBA table F05, using responses to q8f
* if q8f = offset/mortgage, use standard variable home loan rate (5.25), 
//if q8f = personal loan, unsecured personal loan rate (13.9). 
//If anything else, = personal bonus savings rate (2.05).
* value of IFP = alternative interst rate * monthly spend * RPS seasonal factor (Oct) * 12 * share of interst-free period used
* where % of interest free period is based on ccrepay varriable in pre-diary questionnaire

* INTEREST PAID
* = Interest paid in most recent statement * frequency of payments (from ccrepay) 
//Frequency: 12 if 'monthly minimum, nothing more', 3 if 'sometimes in full, sometimes not', 1 if always repay in full. 


* FIXED PARAMETERS
* Seasonal factor: 0.99 for October 2016 is based on RPS credit/charge card isuing personal purchases (from X12 output). 
* ^ The October SF is used because survey was conducted in November, but based on most recent monthly statement at that time

*Interest rates
* Standard variable home loan rate: 5.25 in Nov 2016
* Personal loan: 13.9 in Nov 2016
* Personal bonus online savings rate: 2.05 in Nov 2016
*------------------------------------------------
}

*cd [specify filepath for working directory]
use ".\Data\CCholdingdata.dta", clear

********
* SET UP VARIABLES
********

quietly {
* 1082 credit card holders
drop if ccmainfee>=1000
* ^ drop 13 respondents whose annual fee was above $1000, now 1069 cardholders
* I drop these respondents because they bias mean net benefit estimates downwards 
//by a lot, but these respondents likely accrue other, non-rewards-points monetary 
//benefits that are not included in these calculations (eg free flights or whatevs). 


* For step 1: Rewards
***************
* Annual spend based on monthly credit card statement
gen annualspend1 = (q7e / 0.99) * 12 if q7e>=0
* ^ there is annual spending data for 943 cardholders

gen ccrebate1 = ccmainrebatepct
replace ccrebate1 = ccmain_flightrebate if q7a==3 & ccmain_flightrebate!=.
replace ccrebate1=0 if ccrebate1==-1
label var ccrebate1 "percent rewards rebate, based on redemption for flights for respondents who normally redeem for flights; $100 gift voucher for all other respondents"
* ^ for 146 respondents who said they redeem rewards points for flights, rebate is
//based on the value of rewards redeemed for flights. For all others, based on a $100 gift card.
* ^ we have rewards data on 1007 cardholders

* alternative total main credit card spend (I don't use this)
gen ccpayment = payamt if payamt>0 & (paymeth==3 | paymeth==4) & cc_used == ccmain
egen weeklyccspend = total(ccpayment), by(id)


* For step 2: Annual fee
***************
* Some respondents had their usual/advertised annual fee 
//(which is what appears in the CFD) discounted or waived - we asked about this in q7d of the EOS. 
* Create an annual fee indicator: 0 if waived, 0.5 if discounted, 1 otherwise

*Indicator for whether discounted/waived
gen annualfee_d = .
replace annualfee_d = 1 if ccown == 1
replace annualfee_d = 0 if q7d == 3 | q7d == 4
* for 165 people who say they don't have an annual fee (q7d=4) but CFD says they do, 
//I set annual fee = 0. They may have had it waived but don't realise it 
//(eg if it's part of a mortgage package). 
replace annualfee_d = .5 if q7d == 2
* ^ assume 50% discount 46 people who had their fee discounted
label define annualfee_d 0 "waived (0)" 1 "everyone else - incl zero annual fee (1)"
label val annualfee_d annualfee_d


* For step 3: Value of interest-free period
***************
gen ifp_used = .
replace ifp_used = 1 if ccrepay == 2
* ^ in full, lump sum just before due. 100% of IFP. 

replace ifp_used = 0 if ccrepay == 4
* ^ in full, soon after each purchase. 0% of IFP.

replace ifp_used = 0 if ccrepay == 5
* ^ monthly minimum, nothing more. 0% of IFP because 
//there is no IFP when you have oustanding debt. 

replace ifp_used = 30/ccmainday if ccrepay == 1 & ccmainday >=0
replace ifp_used = 0.6 if ccmainday==-5 & ccrepay==1
* ^ in full, lump sum well before due. Should be 60% of IFP (
//assuming they pay soon after bill arrives - around 30 out of ~ 55 days).
* if ccmaindays is missing from CFD, asume exactly 60%

replace ifp_used = 15/ccmainday if ccrepay == 3 & ccmainday>=0
replace ifp_used = 0.25 if ccrepay == 3 & ccmainday==-5
* ^ in full, regular instalments. Should be ~ 25% of IFP 
//(assuming fortnightly repayments - 14 out of ~55 days).

replace ifp_used = 0.75 if ccrepay == 6
* ^ sometimes in full, sometimes not. Assuming full use of IFP 
//on months that are repaid in full, consistent with step 4 assumption (below) 
//of these respondents paying interest 3 months in a year.
// IFP is obviously not available in the months not paid in full. 

* Note: I am treating 'not sure' and 'someone else looks after this for me' 
//in ccrepay as missing. This means I drop 16 more respondents. 

* Alternative interest rates
* Based on RBA publised monthly averages. 
* Note: some people who selected 1,2,5 probably also have an offset account, 
//so this method may under-estimate value of IFP for those people. 
gen alt_ir1=.
replace alt_ir1 = 0.0525 if q8f == 3
replace alt_ir1 = 0.1390 if q8f == 4
replace alt_ir1 = 0.0205 if inlist(q8f,1,2,5)
* ^ I drop 1 respondent with missing q8f response



* For step 4: Interest paid
******************

gen interest_freq1 = 0 if ccown==1
* ^ includes 16 people who responded 'not sure' or 'someone else looks after this for  me' to ccrepay
* ^ they will have 0 frequency or 1/year frequency, depending on response to q7f
replace interest_freq1 = 1 if !inlist(ccrepay,5,6) & q7f>0
* ^ If they have paid interest in their most recent statement (q7f), 
//take these charges as a one-off if they say in ccrepay that they usually pay off in full
replace interest_freq1 = 3 if ccrepay==6
* ^ if they respond 'sometimes repay in full, sometimes not' assume they pay interest 3 times/year
replace interest_freq1 = 12 if ccrepay==5
* ^ if they respond 'monthly minimum, nothing more' assume same interest charges each month
* Note: the question asks specifically for NEW interest charges, 
//so this is not the value of interst outstanding, but the amount added to the balance each month. 

gen interest_paid =0 if q7b!=-2 & q7b!=-1 & q7f!=-2 
* ^ 57 respondents selected 'prefer not to answer' in q7f (interest charges in most recent statement)
// I exclude these people

********
* CALCULATIONS
********
		* Step 1
		******************
		gen rewards_annualval = 0
		replace rewards_annualval = ccrebate1/100* annualspend1  if annualspend1!=. & ccmainrebate>0
		replace rewards_annualval = . if annualspend1==. 
		* ^ here respondents with missing ccrebate1 are treated as not earning any value from rewards points
		
		* Step 2
		******************
		* $ value of annual fee
		gen annualfee = annualfee_d * ccmainfee if ccmainfee!=-5 & ccmainfee!=-1
		label var annualfee "$ value of annual fee paid, adjusted for waived/discounted"
		* there are 1012 people with annnual fee data (fee is missing for 57 respondents)

		* Step 2.5: Net value of payment function
		******************
		gen netpmtfunction = rewards_annualval - annualfee
		* ^  890 obserations. This method drops 179 observations (123 after weighting)
		//- about 16 per cent of credit card holders. For 56 respondents, 
		//it's because they listed their main CC as 'other' and we couldn't identify it. 
		* a further 116 selected 'prefer not to answer' to q7e, 
		//so were dropped from calculations. 
		
		* Step 3: Interest-free period
		*******************
		* Value of interest free period - assuming balance is accrued in the middle of the month (day 15)
		gen ifp_potential = annualspend1 * alt_ir1 *(ccmainday-15)/365 if ccmainday >0
				label var ifp_potential "Value of IFP if respondent pays off on the due date"
		replace ifp_potential = 0 if ccmainday==0
		*^ There are 3 credit cards in the sample which do not have an interest-free period (interest applies immediately after purchase)
		
		gen ifp_value = ifp_potential * ifp_used
		label var ifp_value "Actual value of IFP based on reported fequency of cc repayments (from ccrepay)"
		* ^ We have this variable for 880 respondents
		
		* Step 4: Interest paid
		*********************
		replace interest_paid = q7f * interest_freq1 if q7f>=0 & q7f!=.

		
		* Step 4.5: Net value of borrowing function
		********************
		gen netborrowingvalue = ifp_value - interest_paid
		* ^ There are now 842 respondents. We are missing data on 227 respondents - 18 per cent of cc holders (some we don't know maincc, 59 prefer not to answer credit card interst paid, 16 not sure/someone else looks after ccrepay, 129 prefer not to answer total card spend)

		* STEP 5: put everything together
		********
		gen netbenefit1111 = netpmtfunction + netborrowingvalue
		*We end up with 841 observations, 80 per cent of credit card holders. 
		
		* Indicator for gain, loss or neutral (where netural is -$50 to +$50)
		gen netdummy1111 = 0 if netbenefit1111!=.
		replace netdummy1111 = 1 if netbenefit1111>50 & netbenefit1111!=.
		replace netdummy1111 = -1 if netbenefit1111<-50
	}
replace netdummy1111=. if ccown==0
replace netbenefit1111=. if ccown==0
replace netborrowingvalue =. if ccown==0
replace interest_paid =. if ccown==0
replace ifp_potential = . if ccown==0
replace netpmtfunction=. if ccown==0
replace rewards_annualval=. if ccown==0
replace interest_freq =. if ccown==0
replace alt_ir1=. if ccown==0
replace ifp_used=. if ccown==0
replace annualfee=. if ccown==0
replace annualfee_d=. if ccown==0
replace annualspend1=. if ccown==0
replace ccrebate=. if ccown==0
*egen netbenefitbins = cut(netbenefit1111), at(-1000(10)1000)
*quietly: tabout netbenefitbins ccmainreward if idtag==1 [aw=w1] using "Cumulative distribution - behaviour constant.xls", f(4) c(col) append
*drop netbenefitbins

* Balance check for missing observations
preserve
* footnote 13?: share with a card I could not identify
tablecol ccmain idtag if idtag==1 & ccown==1 [pw=w1], colpct row nofreq

* footnote 14: characteristics of people with missing net benefit
replace netdummy=-2 if netdummy==. & ccown==1
gen missing = 1 if netdummy==-2 & ccown==1
replace missing=0 if netdummy>=-1 & ccown==1
tablecol missing idtag if idtag==1 [pw=w1], colpct row
tablecol missing idtag if idtag==1, colpct row

tablecol agebin missing if idtag==1 [pw=w1], colpct nofreq
tablecol hhincq missing if idtag==1 [pw=w1], colpct nofreq
tablecol ccmaintype missing if idtag==1 [pw=w1], colpct nofreq
tablecol ccrepay missing if idtag==1 [pw=w1], colpct
tablecol q2d missing if idtag==1 [pw=w1], colpct
tablecol q2c3cc missing if idtag==1 [pw=w1], colpct


restore
* My takeaway: respondents with missing data don't look too different, but
* - they're a little younger with lower income
* - more likely to be credit revolvers, more likely to prefer cash or debit
* - held less positive views about credit cards, esp on usefulness for managing finances
* so it's likely that on average they had lower net monetary benefits than in-sample respondents
